/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.apps.config;

import filenet.vw.apps.config.images.VWImageLoader;
import filenet.vw.apps.config.resources.VWResource;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.admin.IVWConfigActionListener;
import filenet.vw.toolkit.admin.IVWConfigStatusListener;
import filenet.vw.toolkit.admin.VWConfigActionCommand;
import filenet.vw.toolkit.admin.VWConfigActionEvent;
import filenet.vw.toolkit.admin.VWConfigBaseNode;
import filenet.vw.toolkit.admin.VWConfigRegionNode;
import filenet.vw.toolkit.admin.VWConfigRootNode;
import filenet.vw.toolkit.admin.VWConfigStatusEvent;
import filenet.vw.toolkit.admin.VWConfigVWServiceNode;
import filenet.vw.toolkit.design.canvas.config.VWDesignerVWServiceNode;
import filenet.vw.toolkit.utils.VWAccessibilityHelper;
import filenet.vw.toolkit.utils.VWKeyAdapter;
import filenet.vw.toolkit.utils.images.VWToolbarButtonFocusAdapter;
import java.awt.Component;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.FocusManager;
import javax.swing.JButton;
import javax.swing.JToolBar;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class VWConfigToolBar
extends JToolBar
implements ChangeListener,
IVWConfigActionListener,
IVWConfigStatusListener {
    public static final int INTEGRATED_APP_CONFIG = 0;
    public static final int INTEGRATED_APP_DESIGNER = 1;
    protected int m_nIntegratedApp = 0;
    protected boolean m_bEditingSolution = false;
    protected String[] m_buttonNames = null;
    protected ActionListener m_listener = null;
    protected JButton m_actionButton = null;
    protected JButton m_viewButton = null;
    protected AbstractButton m_logonButton = null;
    protected AbstractButton m_logoffButton = null;
    protected AbstractButton m_commitButton = null;
    protected AbstractButton m_discardButton = null;
    protected AbstractButton m_refreshButton = null;
    protected AbstractButton m_propertyButton = null;
    protected AbstractButton m_newButton = null;
    protected AbstractButton m_iconViewButton = null;
    protected AbstractButton m_propertyViewButton = null;
    protected AbstractButton m_upButton = null;
    protected AbstractButton m_helpButton = null;

    public VWConfigToolBar(ActionListener listener) {
        this(listener, 0);
    }

    public VWConfigToolBar(ActionListener listener, int nIntegratedApp) {
        try {
            this.m_listener = listener;
            this.m_nIntegratedApp = nIntegratedApp;
            this.setFloatable(false);
            this.setBorderPainted(false);
            this.createButtons();
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public void requestFocus() {
        if (this.m_actionButton != null && this.m_actionButton.isEnabled()) {
            this.m_actionButton.requestFocus();
        } else if (this.m_commitButton != null) {
            this.m_commitButton.requestFocus();
        }
    }

    public boolean getIsEditingSolution() {
        return this.m_bEditingSolution;
    }

    public void setIsEditingSolution(boolean bEditingSolution) {
        this.m_bEditingSolution = bEditingSolution;
    }

    public void releaseResources() {
        if (this.m_listener == null) {
            return;
        }
        if (this.m_actionButton != null) {
            this.m_actionButton.removeActionListener(this.m_listener);
            this.m_actionButton.removeKeyListener(VWKeyAdapter.s_keyAdapter);
            this.m_actionButton = null;
        }
        if (this.m_viewButton != null) {
            this.m_viewButton.removeActionListener(this.m_listener);
            this.m_viewButton.removeKeyListener(VWKeyAdapter.s_keyAdapter);
            this.m_viewButton = null;
        }
        if (this.m_logonButton != null) {
            this.m_logonButton.removeActionListener(this.m_listener);
            this.m_logonButton.removeKeyListener(VWKeyAdapter.s_keyAdapter);
            this.m_logonButton = null;
        }
        if (this.m_logoffButton != null) {
            this.m_logoffButton.removeActionListener(this.m_listener);
            this.m_logoffButton.removeKeyListener(VWKeyAdapter.s_keyAdapter);
            this.m_logoffButton = null;
        }
        if (this.m_commitButton != null) {
            this.m_commitButton.removeActionListener(this.m_listener);
            this.m_commitButton.removeKeyListener(VWKeyAdapter.s_keyAdapter);
            this.m_commitButton = null;
        }
        if (this.m_discardButton != null) {
            this.m_discardButton.removeActionListener(this.m_listener);
            this.m_discardButton.removeKeyListener(VWKeyAdapter.s_keyAdapter);
            this.m_discardButton = null;
        }
        if (this.m_refreshButton != null) {
            this.m_refreshButton.removeActionListener(this.m_listener);
            this.m_refreshButton.removeKeyListener(VWKeyAdapter.s_keyAdapter);
            this.m_refreshButton = null;
        }
        if (this.m_propertyButton != null) {
            this.m_propertyButton.removeActionListener(this.m_listener);
            this.m_propertyButton.removeKeyListener(VWKeyAdapter.s_keyAdapter);
            this.m_propertyButton = null;
        }
        if (this.m_newButton != null) {
            this.m_newButton.removeActionListener(this.m_listener);
            this.m_newButton.removeKeyListener(VWKeyAdapter.s_keyAdapter);
            this.m_newButton = null;
        }
        if (this.m_iconViewButton != null) {
            this.m_iconViewButton.removeActionListener(this.m_listener);
            this.m_iconViewButton.removeKeyListener(VWKeyAdapter.s_keyAdapter);
            this.m_iconViewButton = null;
        }
        if (this.m_propertyViewButton != null) {
            this.m_propertyViewButton.removeActionListener(this.m_listener);
            this.m_propertyViewButton.removeKeyListener(VWKeyAdapter.s_keyAdapter);
            this.m_propertyViewButton = null;
        }
        if (this.m_upButton != null) {
            this.m_upButton.removeActionListener(this.m_listener);
            this.m_upButton.removeKeyListener(VWKeyAdapter.s_keyAdapter);
            this.m_upButton = null;
        }
        if (this.m_helpButton != null) {
            this.m_helpButton.removeActionListener(this.m_listener);
            this.m_helpButton.removeKeyListener(VWKeyAdapter.s_keyAdapter);
            this.m_helpButton = null;
        }
        this.m_listener = null;
        this.removeAll();
    }

    public void stateChanged(ChangeEvent event) {
        Component focusComponent = FocusManager.getCurrentManager().getFocusOwner();
        if (this.m_actionButton != null && this.m_actionButton.isEnabled() && this.m_actionButton != focusComponent) {
            this.m_actionButton.setBorderPainted(this.m_actionButton.getModel().isRollover());
        }
        if (this.m_viewButton != null && this.m_viewButton.isEnabled() && this.m_viewButton != focusComponent) {
            this.m_viewButton.setBorderPainted(this.m_viewButton.getModel().isRollover());
        }
    }

    public void configActionPerformed(VWConfigActionEvent evt) {
        VWConfigBaseNode aNode = evt.getBaseNode();
        if (evt.changedFocus()) {
            if (aNode.getParent() == null || aNode instanceof VWDesignerVWServiceNode) {
                this.m_upButton.setEnabled(false);
            } else {
                this.m_upButton.setEnabled(true);
                this.m_upButton.setRolloverEnabled(true);
            }
        }
        this.setToolBar(aNode);
    }

    public void configStatusChanged(VWConfigStatusEvent event) {
        VWConfigBaseNode baseNode = event.getBaseNode();
        try {
            if (event.getType() == 2) {
                VWConfigRootNode rootNode = (VWConfigRootNode)baseNode.getRoot();
                if (rootNode.isDirty()) {
                    this.m_commitButton.setEnabled(!this.m_bEditingSolution);
                    this.m_commitButton.setRolloverEnabled(!this.m_bEditingSolution);
                    this.m_discardButton.setEnabled(!this.m_bEditingSolution);
                    this.m_discardButton.setRolloverEnabled(!this.m_bEditingSolution);
                } else {
                    this.m_commitButton.setEnabled(false);
                    this.m_discardButton.setEnabled(false);
                }
            } else {
                this.m_commitButton.setEnabled(!this.m_bEditingSolution);
                this.m_commitButton.setRolloverEnabled(!this.m_bEditingSolution);
                this.m_discardButton.setEnabled(!this.m_bEditingSolution);
                this.m_discardButton.setRolloverEnabled(!this.m_bEditingSolution);
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    protected void createButtons() {
        try {
            this.m_actionButton = new JButton(VWResource.Action);
            this.m_actionButton.addActionListener(this.m_listener);
            this.m_actionButton.setActionCommand(VWResource.Action);
            VWAccessibilityHelper.setAccessibility(this.m_actionButton, this, VWResource.Action, VWResource.Action);
            this.m_actionButton.addKeyListener(VWKeyAdapter.s_keyAdapter);
            this.m_actionButton.getAccessibleContext().setAccessibleName(VWResource.Action);
            this.m_actionButton.addFocusListener(new VWToolbarButtonFocusAdapter(this.m_actionButton));
            this.m_actionButton.setEnabled(true);
            this.m_actionButton.setRolloverEnabled(true);
            this.m_actionButton.setFocusable(true);
            this.m_actionButton.setBorderPainted(false);
            this.m_actionButton.addChangeListener(this);
            this.add(this.m_actionButton);
            if (this.m_nIntegratedApp == 0) {
                this.m_viewButton = new JButton(VWResource.View);
                this.m_viewButton.addActionListener(this.m_listener);
                this.m_viewButton.setActionCommand(VWResource.View);
                VWAccessibilityHelper.setAccessibility(this.m_viewButton, this, VWResource.View, VWResource.View);
                this.m_viewButton.addKeyListener(VWKeyAdapter.s_keyAdapter);
                this.m_viewButton.getAccessibleContext().setAccessibleName(VWResource.View);
                this.m_viewButton.addFocusListener(new VWToolbarButtonFocusAdapter(this.m_viewButton));
                this.m_viewButton.setRolloverEnabled(true);
                this.m_viewButton.setBorderPainted(false);
                this.m_viewButton.addChangeListener(this);
                this.add(this.m_viewButton);
            }
            VWImageLoader.addToolbarSeparator(this);
            if (this.m_nIntegratedApp == 0) {
                this.m_logonButton = VWImageLoader.createToolBarButton("logon.gif", VWConfigActionCommand.ACMD_LOGON, false);
                this.m_logonButton.addActionListener(this.m_listener);
                this.m_logonButton.setActionCommand(VWConfigActionCommand.ACMD_LOGON);
                this.m_logonButton.addKeyListener(VWKeyAdapter.s_keyAdapter);
                this.m_logonButton.getAccessibleContext().setAccessibleName(VWConfigActionCommand.ACMD_LOGON);
                this.m_logonButton.setEnabled(false);
                this.m_logonButton.setRolloverEnabled(true);
                this.m_logonButton.setFocusable(true);
                this.add(this.m_logonButton);
                this.m_logoffButton = VWImageLoader.createToolBarButton("logoff.gif", VWConfigActionCommand.ACMD_LOGOFF, false);
                this.m_logoffButton.addActionListener(this.m_listener);
                this.m_logoffButton.setActionCommand(VWConfigActionCommand.ACMD_LOGOFF);
                this.m_logoffButton.addKeyListener(VWKeyAdapter.s_keyAdapter);
                this.m_logoffButton.setEnabled(false);
                this.m_logoffButton.setRolloverEnabled(true);
                this.add(this.m_logoffButton);
                VWImageLoader.addToolbarSeparator(this);
            }
            this.m_commitButton = VWImageLoader.createToolBarButton("save.gif", VWConfigActionCommand.ACMD_COMMIT, false);
            this.m_commitButton.addActionListener(this.m_listener);
            this.m_commitButton.setActionCommand(VWConfigActionCommand.ACMD_COMMIT);
            this.m_commitButton.addKeyListener(VWKeyAdapter.s_keyAdapter);
            this.m_commitButton.getAccessibleContext().setAccessibleName(VWConfigActionCommand.ACMD_COMMIT);
            this.m_commitButton.setEnabled(false);
            this.m_commitButton.setRolloverEnabled(true);
            this.add(this.m_commitButton);
            this.m_discardButton = VWImageLoader.createToolBarButton("cancel.gif", VWConfigActionCommand.ACMD_DISCARD, false);
            this.m_discardButton.addActionListener(this.m_listener);
            this.m_discardButton.setActionCommand(VWConfigActionCommand.ACMD_DISCARD);
            this.m_discardButton.addKeyListener(VWKeyAdapter.s_keyAdapter);
            this.m_discardButton.setEnabled(false);
            this.m_discardButton.setRolloverEnabled(true);
            this.add(this.m_discardButton);
            this.m_propertyButton = VWImageLoader.createToolBarButton("properties.gif", VWConfigActionCommand.ACMD_PROPERTIES, false);
            this.m_propertyButton.addActionListener(this.m_listener);
            this.m_propertyButton.setActionCommand(VWConfigActionCommand.ACMD_PROPERTIES);
            this.m_propertyButton.addKeyListener(VWKeyAdapter.s_keyAdapter);
            this.m_propertyButton.getAccessibleContext().setAccessibleName(VWConfigActionCommand.ACMD_PROPERTIES);
            this.m_propertyButton.setEnabled(false);
            this.m_propertyButton.setRolloverEnabled(true);
            this.add(this.m_propertyButton);
            this.m_newButton = VWImageLoader.createToolBarButton("new.gif", VWConfigActionCommand.ACMD_NEW, false);
            this.m_newButton.addActionListener(this.m_listener);
            this.m_newButton.setActionCommand(VWConfigActionCommand.ACMD_NEW);
            this.m_newButton.addKeyListener(VWKeyAdapter.s_keyAdapter);
            this.m_newButton.getAccessibleContext().setAccessibleName(VWConfigActionCommand.ACMD_NEW);
            this.m_newButton.setEnabled(false);
            this.m_newButton.setRolloverEnabled(true);
            this.add(this.m_newButton);
            VWImageLoader.addToolbarSeparator(this);
            this.m_refreshButton = VWImageLoader.createToolBarButton("refresh.gif", VWConfigActionCommand.ACMD_REFRESH, false);
            this.m_refreshButton.addActionListener(this.m_listener);
            this.m_refreshButton.setActionCommand(VWConfigActionCommand.ACMD_REFRESH);
            this.m_refreshButton.addKeyListener(VWKeyAdapter.s_keyAdapter);
            this.m_refreshButton.getAccessibleContext().setAccessibleName(VWConfigActionCommand.ACMD_REFRESH);
            this.m_refreshButton.setEnabled(true);
            this.m_refreshButton.setRolloverEnabled(true);
            this.add(this.m_refreshButton);
            this.m_upButton = VWImageLoader.createToolBarButton("up.gif", VWConfigActionCommand.ACMD_UP, false);
            this.m_upButton.addActionListener(this.m_listener);
            this.m_upButton.setActionCommand(VWConfigActionCommand.ACMD_UP);
            this.m_upButton.addKeyListener(VWKeyAdapter.s_keyAdapter);
            this.m_upButton.getAccessibleContext().setAccessibleName(VWConfigActionCommand.ACMD_UP);
            this.m_upButton.setEnabled(true);
            this.m_upButton.setRolloverEnabled(true);
            this.add(this.m_upButton);
            VWImageLoader.addToolbarSeparator(this);
            this.m_helpButton = VWImageLoader.createToolBarButton("help.gif", VWConfigActionCommand.ACMD_HELP_TOPICS, false);
            this.m_helpButton.addActionListener(this.m_listener);
            this.m_helpButton.setActionCommand(VWConfigActionCommand.ACMD_HELP_TOPICS);
            this.m_helpButton.addKeyListener(VWKeyAdapter.s_keyAdapter);
            this.m_helpButton.getAccessibleContext().setAccessibleName(VWConfigActionCommand.ACMD_HELP_TOPICS);
            this.m_helpButton.setEnabled(true);
            this.m_helpButton.setRolloverEnabled(true);
            this.add(this.m_helpButton);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    protected void setToolBar(VWConfigBaseNode baseNode) {
        VWConfigRegionNode regionNode;
        VWConfigVWServiceNode serviceNode;
        boolean bIsDirty = false;
        if (this.m_actionButton != null) {
            this.m_actionButton.setEnabled(true);
            this.m_actionButton.setRolloverEnabled(true);
        }
        switch (baseNode.getType()) {
            case 17: {
                if (this.m_actionButton != null && this.m_nIntegratedApp == 1) {
                    this.m_actionButton.setEnabled(false);
                }
                VWConfigRootNode rootNode = (VWConfigRootNode)baseNode;
                bIsDirty = rootNode.isDirty();
                if (this.m_logonButton != null) {
                    this.m_logonButton.setEnabled(false);
                }
                if (this.m_logoffButton == null) break;
                this.m_logoffButton.setEnabled(false);
                break;
            }
            case 18: {
                if (this.m_actionButton != null && this.m_nIntegratedApp == 1) {
                    this.m_actionButton.setEnabled(false);
                }
                serviceNode = (VWConfigVWServiceNode)baseNode;
                bIsDirty = serviceNode.isDirty();
                if (this.m_logonButton != null) {
                    this.m_logonButton.setEnabled(false);
                }
                if (this.m_logoffButton == null) break;
                this.m_logoffButton.setEnabled(false);
                break;
            }
            case 19: {
                regionNode = (VWConfigRegionNode)baseNode;
                bIsDirty = regionNode.isDirty();
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 16: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                if (this.m_logonButton != null) {
                    this.m_logonButton.setEnabled(false);
                }
                if (this.m_logoffButton != null) {
                    this.m_logoffButton.setEnabled(true);
                    this.m_logoffButton.setRolloverEnabled(true);
                }
                if ((regionNode = (VWConfigRegionNode)baseNode.findAncestorNode(19)) == null) break;
                bIsDirty = regionNode.isDirty();
                break;
            }
        }
        if (bIsDirty) {
            this.m_commitButton.setEnabled(!this.m_bEditingSolution);
            this.m_commitButton.setRolloverEnabled(!this.m_bEditingSolution);
            this.m_discardButton.setEnabled(!this.m_bEditingSolution);
            this.m_discardButton.setRolloverEnabled(!this.m_bEditingSolution);
        } else {
            this.m_commitButton.setEnabled(false);
            this.m_discardButton.setEnabled(false);
        }
        this.m_refreshButton.setEnabled(!this.m_bEditingSolution);
        this.m_refreshButton.setRolloverEnabled(!this.m_bEditingSolution);
        switch (baseNode.getType()) {
            case 17: {
                this.m_propertyButton.setEnabled(false);
                this.m_newButton.setEnabled(false);
                break;
            }
            case 18: {
                serviceNode = (VWConfigVWServiceNode)baseNode;
                this.m_propertyButton.setActionCommand(VWConfigActionCommand.ACMD_SYSTEM_PROPERTIES);
                if (serviceNode.activeRegionCount() > 0) {
                    this.m_propertyButton.setEnabled(true);
                    this.m_propertyButton.setRolloverEnabled(true);
                } else {
                    this.m_propertyButton.setEnabled(false);
                }
                this.m_newButton.setEnabled(false);
                break;
            }
            case 19: {
                this.m_propertyButton.setActionCommand(VWConfigActionCommand.ACMD_REGION_PROPERTIES);
                regionNode = (VWConfigRegionNode)baseNode;
                if (regionNode.getSession() != null) {
                    if (regionNode.isRegionInitialized()) {
                        this.m_propertyButton.setEnabled(true);
                    } else {
                        this.m_propertyButton.setEnabled(false);
                    }
                    this.m_propertyButton.setRolloverEnabled(true);
                    if (this.m_logonButton != null) {
                        this.m_logonButton.setEnabled(false);
                    }
                    if (this.m_logoffButton != null) {
                        this.m_logoffButton.setEnabled(true);
                        this.m_logoffButton.setRolloverEnabled(true);
                    }
                } else {
                    this.m_propertyButton.setEnabled(false);
                    if (this.m_logonButton != null) {
                        this.m_logonButton.setEnabled(true);
                        this.m_logonButton.setRolloverEnabled(true);
                    }
                    if (this.m_logoffButton != null) {
                        this.m_logoffButton.setEnabled(false);
                    }
                }
                this.m_newButton.setEnabled(false);
                break;
            }
            case 24: {
                this.m_newButton.setActionCommand(VWConfigActionCommand.ACMD_NEW_COMPONENT);
                this.m_propertyButton.setEnabled(false);
                this.m_newButton.setEnabled(true);
                this.m_newButton.setRolloverEnabled(true);
                break;
            }
            case 5: {
                this.m_propertyButton.setActionCommand(VWConfigActionCommand.ACMD_COMPONENT_PROPERTIES);
                this.m_propertyButton.setEnabled(true);
                this.m_propertyButton.setRolloverEnabled(true);
                this.m_newButton.setEnabled(false);
                break;
            }
            case 20: {
                this.m_newButton.setActionCommand(VWConfigActionCommand.ACMD_NEW_QUEUE);
                this.m_propertyButton.setEnabled(false);
                this.m_newButton.setEnabled(true);
                this.m_newButton.setRolloverEnabled(true);
                break;
            }
            case 1: {
                this.m_propertyButton.setActionCommand(VWConfigActionCommand.ACMD_QUEUE_PROPERTIES);
                this.m_propertyButton.setEnabled(true);
                this.m_propertyButton.setRolloverEnabled(true);
                this.m_newButton.setEnabled(false);
                break;
            }
            case 21: {
                this.m_newButton.setActionCommand(VWConfigActionCommand.ACMD_NEW_QUEUE);
                this.m_propertyButton.setEnabled(false);
                this.m_newButton.setEnabled(false);
                break;
            }
            case 2: {
                this.m_propertyButton.setActionCommand(VWConfigActionCommand.ACMD_QUEUE_PROPERTIES);
                this.m_propertyButton.setEnabled(true);
                this.m_propertyButton.setRolloverEnabled(true);
                this.m_newButton.setEnabled(false);
                break;
            }
            case 22: {
                this.m_newButton.setActionCommand(VWConfigActionCommand.ACMD_NEW_ROSTER);
                this.m_propertyButton.setEnabled(false);
                this.m_newButton.setEnabled(true);
                this.m_newButton.setRolloverEnabled(true);
                break;
            }
            case 3: {
                this.m_propertyButton.setActionCommand(VWConfigActionCommand.ACMD_ROSTER_PROPERTIES);
                this.m_propertyButton.setEnabled(true);
                this.m_propertyButton.setRolloverEnabled(true);
                this.m_newButton.setEnabled(false);
                break;
            }
            case 23: {
                this.m_newButton.setActionCommand(VWConfigActionCommand.ACMD_NEW_EVENTLOG);
                this.m_propertyButton.setEnabled(false);
                this.m_newButton.setEnabled(true);
                this.m_newButton.setRolloverEnabled(true);
                break;
            }
            case 4: {
                this.m_propertyButton.setActionCommand(VWConfigActionCommand.ACMD_EVENTLOG_PROPERTIES);
                this.m_propertyButton.setEnabled(true);
                this.m_propertyButton.setRolloverEnabled(true);
                this.m_newButton.setEnabled(false);
                break;
            }
            case 25: {
                this.m_newButton.setActionCommand(VWConfigActionCommand.ACMD_NEW_APPSPACE);
                this.m_propertyButton.setEnabled(false);
                this.m_newButton.setEnabled(true);
                this.m_newButton.setRolloverEnabled(true);
                break;
            }
            case 6: {
                this.m_propertyButton.setActionCommand(VWConfigActionCommand.ACMD_APPSPACE_PROPERTIES);
                this.m_propertyButton.setEnabled(true);
                this.m_propertyButton.setRolloverEnabled(true);
                this.m_newButton.setEnabled(false);
                break;
            }
            case 16: {
                this.m_propertyButton.setEnabled(false);
                this.m_newButton.setEnabled(false);
            }
        }
    }
}

